/*=========================================================

	heap.c

	q[vƂĎgp郁̈쐬B
	傫̕Ă̂𕡐mۂꍇɗLB

=========================================================*/
#include "heap.h"

/*=========================================================
	}N
=========================================================*/
#define HEAP_ALIGN_SIZE 8

/*=========================================================
	֐
=========================================================*/
HeapUID heapCreateEx( const char *name, MemoryPartition partition, unsigned int align, SceSize size, int type, void *addr )
{
	struct heap_allocated_memblock_header *heap_root = (struct heap_allocated_memblock_header *)memoryAllocEx( name, partition, align, size + sizeof( struct heap_allocated_memblock_header ), type, addr );
	if( heap_root ){
		heap_root->next = NULL;
		heap_root->size = memoryUsableSize( (void *)heap_root ) - sizeof( struct heap_allocated_memblock_header );
	}
	
	return (HeapUID)heap_root;
}

HeapUID heapCreate( SceSize size )
{
	return (HeapUID)heapCreateEx( "cg_user_heap", MEMORY_USER, 0, size, PSP_SMEM_Low, NULL );
}

void heapDestroy( HeapUID uid )
{
	memoryFree( (void *)uid );
}

void *heapAlloc( HeapUID uid, SceSize size )
{
	struct heap_allocated_memblock_header *cur  = (struct heap_allocated_memblock_header *)uid;
	struct heap_allocated_memblock_header *prev = NULL;
	struct heap_allocated_memblock_header *heap = NULL;
	SceSize alloc_size;
	
	/* mۂTCY0̏ꍇ́A1w肳ꂽ̂ƌȂ */
	if( ! size ) size = 1;
	
	alloc_size = size + sizeof( struct heap_allocated_memblock_header ) + HEAP_ALIGN_SIZE;
	
	/* 擪vf̓q[vŜ̏Ƃēʈ */
	if( ! cur->next ){
		if( cur->size < alloc_size ) return NULL;
		cur->next = (struct heap_allocated_memblock_header *)MEMORY_ALIGN_ADDR( HEAP_ALIGN_SIZE, ( (uintptr_t)cur + sizeof( struct heap_allocated_memblock_header ) ) );
		cur->next->size = alloc_size;
		cur->next->next = NULL;
		return (void *)( (uintptr_t)cur->next + sizeof( struct heap_allocated_memblock_header ) );
	} else{
		/* ł蓖ĂĂ΁Arootƍŏ̗vf̊Ԃɋ󂫗eʂȂ */
		struct heap_allocated_memblock_header *topheap = (struct heap_allocated_memblock_header *)( (uintptr_t)cur + sizeof( struct heap_allocated_memblock_header ) );
		
		if( (uintptr_t)(cur->next) - (uintptr_t)topheap >= alloc_size ){
			topheap->size = alloc_size;
			topheap->next = cur->next;
			cur->next = (struct heap_allocated_memblock_header *)MEMORY_ALIGN_ADDR( HEAP_ALIGN_SIZE, topheap );
			return (void *)( (uintptr_t)topheap + sizeof( struct heap_allocated_memblock_header ) );
		}
	}
	
	prev = cur->next;
	cur  = prev->next;
	
	/* \ȋ󂫗eʂTĎ擾 */
	for( ; cur; prev = cur, cur = cur->next ){
		/*
			ÕubN̏I[(prev + prev->size)ƌ݂̃ubN(cur)̍A
			gpTCYZoAKvȗeʂ󂢂ĂΎgpAłȂΎցB
		*/
		if( (uintptr_t)cur - ( (uintptr_t)prev + prev->size ) >= alloc_size ){
			heap = (struct heap_allocated_memblock_header *)MEMORY_ALIGN_ADDR( HEAP_ALIGN_SIZE, ( (uintptr_t)prev + prev->size ) );
			heap->size = alloc_size;
			heap->next = prev->next;
			prev->next = heap;
			break;
		}
	}
	
	/*
		̎_Ŋ蓖ĂĂȂꍇAprevƂ̃ubNwĂ̂ŁA
		q[v̏I[prev̏I[̍疖̋󂫃`FbNB
	*/
	
	if( ! heap &&  ( ( (uintptr_t)uid + ((struct heap_allocated_memblock_header *)uid)->size ) - ( (uintptr_t)prev + prev->size ) >= alloc_size ) ){
		heap = (struct heap_allocated_memblock_header *)MEMORY_ALIGN_ADDR( HEAP_ALIGN_SIZE, ( (uintptr_t)prev + prev->size ) );
		heap->size = alloc_size;
		heap->next = prev->next;
		prev->next = heap;
	}
	
	return heap ? (void *)( (uintptr_t)heap + sizeof( struct heap_allocated_memblock_header ) ) : NULL;
}

void *heapCalloc( HeapUID uid, SceSize size )
{
	void *heap = heapAlloc( uid, size );
	
	if( heap ) memset( heap, 0, size );
	
	return heap;
}

int heapFree( HeapUID uid, void *ptr )
{
	struct heap_allocated_memblock_header *root;
	struct heap_allocated_memblock_header *cur;
	struct heap_allocated_memblock_header *prev;
	struct heap_allocated_memblock_header *heap;
	
	if( ! ptr ) return CG_ERROR_OK;
	
	root = (struct heap_allocated_memblock_header *)uid;
	cur  = NULL;
	prev = NULL;
	heap = (struct heap_allocated_memblock_header *)( (uintptr_t)ptr - sizeof( struct heap_allocated_memblock_header ) );
	
	/* 擪vf̓q[vŜ̏Ƃēʈ */
	if( ! root->next ){
		/* 擪̎Ȃꍇ́A͉蓖ĂĂȂ */
		return CG_ERROR_INVALID_ARGUMENT;
	} else{
		cur = root->next;
	}
	
	for( ; cur != heap; prev = cur, cur = cur->next ){
		/* curNULLɂȂ܂ŉꍇÃAhX͎gpĂȂ */
		if( ! cur ) return CG_ERROR_INVALID_ARGUMENT;
	}
	
	/*
		ΏۃubN̑ÕubNAΏۃubN̎wƂŁA
		ΏۃubN͖gpƂĈB
	*/
	if( prev ){
		prev->next = cur->next;
	} else{
		/* prevꍇ́Aq[v̐擪Ȃ̂ŁAroot̃NύX */
		root->next = cur->next;
	}
	
	return CG_ERROR_OK;
}

SceSize heapUsableSize( HeapUID uid )
{
	return ((struct heap_allocated_memblock_header *)uid)->size;
}

SceSize heapMaxFreeSize( HeapUID uid )
{
	SceSize maxsize, freesize;
	uintptr_t endaddr;
	struct heap_allocated_memblock_header *cur = (struct heap_allocated_memblock_header *)uid;
	struct heap_allocated_memblock_header *prev;
	
	if( ! cur->next ){
		return cur->size;
	} else{
		endaddr = (uintptr_t)cur + cur->size;
		prev = (struct heap_allocated_memblock_header *)((uintptr_t)cur + sizeof( struct heap_allocated_memblock_header ));
		cur  = cur->next;
		
		/* rootƍŏ̗vf̊Ԃ̋󂫗eʂvZ */
		maxsize = (uintptr_t)cur - (uintptr_t)prev;
		
		prev = cur;
		cur  = cur->next;
	}
	
	for( maxsize = 0; cur; prev = cur, cur = cur->next ){
		freesize = (uintptr_t)cur - ( (uintptr_t)prev + prev->size );
		if( maxsize < freesize ) maxsize = freesize;
	}
	
	
	freesize = endaddr - ( (uintptr_t)prev + prev->size );
	if( maxsize < freesize ) maxsize = freesize;
	
	return maxsize;
}

SceSize heapTotalFreeSize( HeapUID uid )
{
	SceSize totalsize = 0;
	struct heap_allocated_memblock_header *cur = (struct heap_allocated_memblock_header *)uid;
	
	if( ! cur->next ){
		return cur->size;
	} else{
		totalsize = cur->size;
		cur = cur->next;
	}
	
	for( ; cur; cur = cur->next ){
		totalsize -= cur->size;
	}
	
	return totalsize;
}
